/*
 * Decompiled with CFR 0.152.
 */
package net.moddingplayground.twigs.impl.data;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4917;
import net.minecraft.class_4925;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4946;
import net.minecraft.class_5794;
import net.moddingplayground.frame.api.toymaker.v0.model.ModelHelpers;
import net.moddingplayground.frame.api.toymaker.v0.model.uploader.BlockStateModelUploader;
import net.moddingplayground.frame.api.toymaker.v0.model.uploader.ItemModelUploader;
import net.moddingplayground.twigs.api.block.BambooLeavesBlock;
import net.moddingplayground.twigs.api.block.TwigsBlocks;
import net.moddingplayground.twigs.api.data.TwigsBlockFamilies;
import net.moddingplayground.twigs.api.item.TwigsItems;

public class ModelProvider
extends FabricModelProvider {
    private BlockStateModelUploader blockUploader;
    private class_4910 blockGen;

    public ModelProvider(FabricDataGenerator gen) {
        super(gen);
    }

    public void generateBlockStateModels(class_4910 gen) {
        BlockStateModelUploader uploader = this.blockUploader = BlockStateModelUploader.of((class_4910)gen);
        this.blockGen = gen;
        uploader.registerWallPlantThin(new class_2248[]{TwigsBlocks.AZALEA_FLOWERS, TwigsBlocks.PETRIFIED_LICHEN});
        uploader.registerFlowerPot(class_4910.class_4913.field_22840, new class_2248[]{TwigsBlocks.POTTED_AZALEA_FLOWERS});
        uploader.registerRotatingIntProperty(BambooLeavesBlock.LAYERS, new class_2248[]{TwigsBlocks.BAMBOO_LEAVES});
        uploader.register(class_4946.field_23038, new class_2248[]{TwigsBlocks.CHISELED_BRICKS, TwigsBlocks.CRIMSON_SHROOMLAMP, TwigsBlocks.WARPED_SHROOMLAMP});
        uploader.register(TwigsTexturedModels.TEMPLATE_MAT, new class_2248[]{TwigsBlocks.STRIPPED_BAMBOO_MAT});
        uploader.registerAxisRotated(TwigsTexturedModels.TEMPLATE_QUAD_POLE, new class_2248[]{TwigsBlocks.STRIPPED_BAMBOO});
        uploader.registerGeneratedItemModel(new class_2248[]{TwigsBlocks.STRIPPED_BAMBOO});
        this.registerTable(TwigsBlocks.OAK_TABLE, TwigsBlocks.SPRUCE_TABLE, TwigsBlocks.BIRCH_TABLE, TwigsBlocks.JUNGLE_TABLE, TwigsBlocks.ACACIA_TABLE, TwigsBlocks.DARK_OAK_TABLE, TwigsBlocks.MANGROVE_TABLE, TwigsBlocks.CRIMSON_TABLE, TwigsBlocks.WARPED_TABLE, TwigsBlocks.STRIPPED_BAMBOO_TABLE);
        this.registerLamp(TwigsBlocks.LAMP, TwigsBlocks.SOUL_LAMP);
        uploader.registerAxisRotatedColumn(new class_2248[]{TwigsBlocks.RHYOLITE, TwigsBlocks.BUNDLED_BAMBOO, TwigsBlocks.STRIPPED_BUNDLED_BAMBOO, TwigsBlocks.POLISHED_BASALT_BRICKS, TwigsBlocks.COPPER_PILLAR, TwigsBlocks.EXPOSED_COPPER_PILLAR, TwigsBlocks.WEATHERED_COPPER_PILLAR, TwigsBlocks.OXIDIZED_COPPER_PILLAR});
        this.registerAxisRotatedColumnParented(TwigsBlocks.COPPER_PILLAR, TwigsBlocks.WAXED_COPPER_PILLAR);
        this.registerAxisRotatedColumnParented(TwigsBlocks.EXPOSED_COPPER_PILLAR, TwigsBlocks.WAXED_EXPOSED_COPPER_PILLAR);
        this.registerAxisRotatedColumnParented(TwigsBlocks.WEATHERED_COPPER_PILLAR, TwigsBlocks.WAXED_WEATHERED_COPPER_PILLAR);
        this.registerAxisRotatedColumnParented(TwigsBlocks.OXIDIZED_COPPER_PILLAR, TwigsBlocks.WAXED_OXIDIZED_COPPER_PILLAR);
        uploader.registerVaryingFloorLayers(2, new class_2248[]{TwigsBlocks.TWIG, TwigsBlocks.PEBBLE});
        uploader.registerVaryingFloorLayers(6, new class_2248[]{TwigsBlocks.SEA_SHELL});
        this.registerPaperLanterns(TwigsBlocks.PAPER_LANTERN, TwigsBlocks.ALLIUM_PAPER_LANTERN, TwigsBlocks.BLUE_ORCHID_PAPER_LANTERN, TwigsBlocks.CRIMSON_ROOTS_PAPER_LANTERN, TwigsBlocks.DANDELION_PAPER_LANTERN);
        List.of(TwigsBlocks.BAMBOO_THATCH, TwigsBlocks.CRACKED_BRICKS, TwigsBlocks.MOSSY_BRICKS, TwigsBlocks.SMOOTH_BASALT_BRICKS, TwigsBlocks.COBBLESTONE_BRICKS, TwigsBlocks.CRACKED_COBBLESTONE_BRICKS, TwigsBlocks.MOSSY_COBBLESTONE_BRICKS, TwigsBlocks.POLISHED_AMETHYST_BRICKS, TwigsBlocks.CRACKED_POLISHED_AMETHYST_BRICKS, TwigsBlocks.POLISHED_AMETHYST, TwigsBlocks.CHISELED_POLISHED_AMETHYST, TwigsBlocks.TWISTING_POLISHED_BLACKSTONE_BRICKS, TwigsBlocks.WEEPING_POLISHED_BLACKSTONE_BRICKS, TwigsBlocks.ROCKY_DIRT, TwigsBlocks.POLISHED_TUFF, TwigsBlocks.POLISHED_TUFF_BRICKS, TwigsBlocks.CRACKED_POLISHED_TUFF_BRICKS, TwigsBlocks.POLISHED_CALCITE, TwigsBlocks.POLISHED_CALCITE_BRICKS, TwigsBlocks.CRACKED_POLISHED_CALCITE_BRICKS, TwigsBlocks.POLISHED_RHYOLITE, TwigsBlocks.POLISHED_RHYOLITE_BRICKS, TwigsBlocks.CRACKED_POLISHED_RHYOLITE_BRICKS, TwigsBlocks.SCHIST, TwigsBlocks.POLISHED_SCHIST, TwigsBlocks.POLISHED_SCHIST_BRICKS, TwigsBlocks.CRACKED_POLISHED_SCHIST_BRICKS, TwigsBlocks.BLOODSTONE, TwigsBlocks.POLISHED_BLOODSTONE, TwigsBlocks.POLISHED_BLOODSTONE_BRICKS, TwigsBlocks.CRACKED_POLISHED_BLOODSTONE_BRICKS, TwigsBlocks.STRIPPED_BAMBOO_PLANKS, TwigsBlocks.ENDER_MESH).forEach(arg_0 -> ((class_4910)gen).method_25641(arg_0));
        TwigsBlockFamilies.FAMILIES.forEach((base, family) -> {
            if (!family.method_33477()) {
                return;
            }
            this.registerIfPresent((class_5794)family, class_5794.class_5796.field_28540, stairs -> uploader.registerStairs(TwigsTextureMap::sideTopBottomNoSuffix, stairs, base));
            this.registerIfPresent((class_5794)family, class_5794.class_5796.field_28539, slab -> uploader.registerSlab(TwigsTextureMap::sideTopBottomNoSuffix, slab, base));
            this.registerIfPresent((class_5794)family, class_5794.class_5796.field_28544, wall -> uploader.registerWall(class_4944::method_27168, wall, base));
            this.registerIfPresent((class_5794)family, class_5794.class_5796.field_28536, fence -> uploader.registerFence(class_4944::method_25872, fence, base));
            this.registerIfPresent((class_5794)family, class_5794.class_5796.field_28537, fenceGate -> uploader.registerFenceGate(class_4944::method_25872, fenceGate, base));
            this.registerIfPresent((class_5794)family, class_5794.class_5796.field_28533, button -> uploader.registerButton(class_4944::method_25872, button, base));
            this.registerIfPresent((class_5794)family, class_5794.class_5796.field_28541, pressurePlate -> uploader.registerPressurePlate(class_4944::method_25872, pressurePlate, base));
            this.registerIfPresent((class_5794)family, class_5794.class_5796.field_28535, arg_0 -> ((class_4910)gen).method_25658(arg_0));
            this.registerIfPresent((class_5794)family, class_5794.class_5796.field_28543, arg_0 -> ((class_4910)gen).method_25665(arg_0));
            this.registerIfPresent((class_5794)family, class_5794.class_5796.field_28538, sign -> uploader.registerSign(class_4944::method_25901, sign, family.method_33470(class_5794.class_5796.field_28545), base));
        });
        class_156.method_654((Object)TwigsBlocks.RHYOLITE, base -> {
            uploader.registerStairs(TwigsTextureMap::stairsColumn, TwigsBlocks.RHYOLITE_STAIRS, base);
            uploader.registerSlab(TwigsTextureMap::column, TwigsBlocks.RHYOLITE_SLAB, base);
            this.registerWallColumn(TwigsTextureMap::column, TwigsBlocks.RHYOLITE_WALL, (class_2248)base);
        });
    }

    public void registerIfPresent(class_5794 family, class_5794.class_5796 variant, Consumer<class_2248> action) {
        this.blockUploader.registerIfPresent(family, variant, ModelHelpers.namespacePredicate((String)"twigs"), action);
    }

    public void registerAxisRotatedColumnParented(class_2248 parent, class_2248 block) {
        class_2960 model = class_4941.method_25842((class_2248)parent);
        this.blockUploader.accept(class_4910.method_25653((class_2248)block, (class_2960)model));
        this.blockGen.method_25623(block, model);
    }

    public void registerTable(class_2248 ... blocks) {
        for (class_2248 block : blocks) {
            this.blockUploader.accept((class_4917)class_4925.method_25770((class_2248)block, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)this.blockUploader.upload(TwigsTexturedModels.TEMPLATE_TABLE, block))).method_25775(class_4910.method_25630()));
        }
    }

    public void registerLamp(class_2248 ... blocks) {
        for (class_2248 block : blocks) {
            class_2960 off = this.blockUploader.upload(class_4946.field_23040.method_35912(TwigsTextureMap.sideOff(block)), block, "_off");
            class_2960 regular = this.blockUploader.upload(class_4946.field_23040, block);
            this.blockUploader.accept((class_4917)class_4925.method_25769((class_2248)block).method_25775(class_4910.method_25565((class_2746)class_2741.field_12548, (class_2960)regular, (class_2960)off)));
        }
    }

    public void registerPaperLanterns(class_2248 ... blocks) {
        for (class_2248 block : blocks) {
            class_2960 standing = this.blockUploader.upload(TwigsTexturedModels.TEMPLATE_PAPER_LANTERN, block);
            class_2960 hanging = this.blockUploader.upload(TwigsTexturedModels.TEMPLATE_PAPER_LANTERN_HANGING, block);
            this.blockUploader.accept((class_4917)class_4925.method_25769((class_2248)block).method_25775(class_4910.method_25565((class_2746)class_2741.field_16561, (class_2960)hanging, (class_2960)standing)));
            this.blockUploader.registerGeneratedItemModel(new class_2248[]{block});
        }
    }

    public void registerWallColumn(Function<class_2248, class_4944> textureMapFunction, class_2248 block, class_2248 base) {
        class_4944 textureMap = textureMapFunction.apply(base);
        class_2960 post = this.blockUploader.upload(TwigsModels.TEMPLATE_WALL_COLUMN_POST, block, textureMap);
        class_2960 side = this.blockUploader.upload(TwigsModels.TEMPLATE_WALL_COLUMN_SIDE, block, textureMap);
        class_2960 sideTall = this.blockUploader.upload(TwigsModels.TEMPLATE_WALL_COLUMN_SIDE_TALL, block, textureMap);
        this.blockUploader.accept(class_4910.method_25636((class_2248)block, (class_2960)post, (class_2960)side, (class_2960)sideTall));
        class_2960 inventory = this.blockUploader.upload(TwigsModels.TEMPLATE_WALL_COLUMN_INVENTORY, block, textureMap);
        this.blockGen.method_25623(block, inventory);
    }

    public void generateItemModels(class_4915 gen) {
        ItemModelUploader uploader = ItemModelUploader.of((class_4915)gen);
        uploader.register(class_4943.field_22938, new class_1792[]{TwigsItems.STRIPPED_BAMBOO_BOAT, TwigsItems.STRIPPED_BAMBOO_CHEST_BOAT});
    }

    public static interface TwigsTexturedModels {
        public static final class_4946.class_4947 TEMPLATE_QUAD_POLE = class_4946.method_25918(TwigsTextureMap::textureStalk, (class_4942)TwigsModels.TEMPLATE_QUAD_POLE);
        public static final class_4946.class_4947 TEMPLATE_MAT = class_4946.method_25918(class_4944::method_25872, (class_4942)TwigsModels.TEMPLATE_MAT);
        public static final class_4946.class_4947 TEMPLATE_TABLE = class_4946.method_25918(class_4944::method_25898, (class_4942)TwigsModels.TEMPLATE_TABLE);
        public static final class_4946.class_4947 TEMPLATE_PAPER_LANTERN = class_4946.method_25918(TwigsTextureMap::paperLantern, (class_4942)TwigsModels.TEMPLATE_PAPER_LANTERN);
        public static final class_4946.class_4947 TEMPLATE_PAPER_LANTERN_HANGING = class_4946.method_25918(TwigsTextureMap::paperLantern, (class_4942)TwigsModels.TEMPLATE_PAPER_LANTERN_HANGING);
    }

    public static interface TwigsTextureMap {
        public static class_4944 paperLantern(class_2248 block) {
            return new class_4944().method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)TwigsBlocks.PAPER_LANTERN, (String)"_top")).method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)block, (String)"_side")).method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)TwigsBlocks.PAPER_LANTERN, (String)"_bottom"));
        }

        public static class_4944 sideTopBottomNoSuffix(class_2248 block) {
            class_2960 id = class_4944.method_25860((class_2248)block);
            return new class_4944().method_25868(class_4945.field_23015, id).method_25868(class_4945.field_23018, id).method_25868(class_4945.field_23014, id);
        }

        public static class_4944 stairsColumn(class_2248 block) {
            class_2960 end = class_4944.method_25866((class_2248)block, (String)"_top");
            class_2960 side = class_4944.method_25866((class_2248)block, (String)"_side");
            return new class_4944().method_25868(class_4945.field_23015, end).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23014, end);
        }

        public static class_4944 column(class_2248 block) {
            class_2960 end = class_4944.method_25866((class_2248)block, (String)"_top");
            class_2960 side = class_4944.method_25866((class_2248)block, (String)"_side");
            return new class_4944().method_25868(class_4945.field_23015, end).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23014, end);
        }

        public static Consumer<class_4944> sideOff(class_2248 block) {
            return textureMap -> textureMap.method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)block, (String)"_side_off"));
        }

        public static class_4944 textureStalk(class_2248 block) {
            class_2960 identifier = class_4944.method_25866((class_2248)block, (String)"_stalk");
            return class_4944.method_25869((class_2960)identifier);
        }
    }

    public static interface TwigsModels {
        public static final class_4945[] SIDE_TOP_BOTTOM = new class_4945[]{class_4945.field_23018, class_4945.field_23015, class_4945.field_23014};
        public static final class_4942 TEMPLATE_WALL_COLUMN_INVENTORY = TwigsModels.block("template_wall_column_inventory", "_inventory", SIDE_TOP_BOTTOM);
        public static final class_4942 TEMPLATE_WALL_COLUMN_POST = TwigsModels.block("template_wall_column_post", "_post", SIDE_TOP_BOTTOM);
        public static final class_4942 TEMPLATE_WALL_COLUMN_SIDE = TwigsModels.block("template_wall_column_side", "_side", SIDE_TOP_BOTTOM);
        public static final class_4942 TEMPLATE_WALL_COLUMN_SIDE_TALL = TwigsModels.block("template_wall_column_side_tall", "_side_tall", SIDE_TOP_BOTTOM);
        public static final class_4942 TEMPLATE_QUAD_POLE = TwigsModels.block("template_quad_pole", class_4945.field_23011);
        public static final class_4942 TEMPLATE_MAT = TwigsModels.block("template_mat", class_4945.field_23011);
        public static final class_4942 TEMPLATE_TABLE = TwigsModels.block("template_table", SIDE_TOP_BOTTOM);
        public static final class_4942 TEMPLATE_PAPER_LANTERN = TwigsModels.block("template_paper_lantern", SIDE_TOP_BOTTOM);
        public static final class_4942 TEMPLATE_PAPER_LANTERN_HANGING = TwigsModels.block("template_paper_lantern_hanging", "_hanging", SIDE_TOP_BOTTOM);

        public static class_4942 make(class_4945 ... keys) {
            return new class_4942(Optional.empty(), Optional.empty(), keys);
        }

        public static class_4942 block(String parent, class_4945 ... keys) {
            return new class_4942(Optional.of(new class_2960("twigs", "block/" + parent)), Optional.empty(), keys);
        }

        public static class_4942 item(String parent, class_4945 ... keys) {
            return new class_4942(Optional.of(new class_2960("twigs", "item/" + parent)), Optional.empty(), keys);
        }

        public static class_4942 block(String parent, String variant, class_4945 ... keys) {
            return new class_4942(Optional.of(new class_2960("twigs", "block/" + parent)), Optional.of(variant), keys);
        }
    }
}

